
#pragma rtGlobals = 1		// in WaveMetrics Procedures folder
#include "IN2_GeneralProcedures"

#include <Strings as Lists>

Menu "Plot&fit"
	Submenu "Major Tools"
	"DWS Plotting tool/1",IR2D_DWSPlotToolMain()
	//"Background Subtraction Tool/2",DWS_DataManipulationPanel()
	end

	submenu "Draw slopes"
			"Draw Line Of Any Slope", DWS_DrawLineOfAnySlope()
			"Draw Line Of -4 Slope",  DWS_DrawLineOfSlope(4)
			"Draw Line Of -3 Slope",  DWS_DrawLineOfSlope(3)
			"Draw Line Of -2 Slope",  DWS_DrawLineOfSlope(2)	
	end
		"-"
	Submenu "Plotting Utilities"
		"Standard Size Graph", StdGraph()
		"Find Path To Cursor a Trace In Graph",FindPath2cursorWave()//FindcursorTrace()
		"Find Cursor a trace name",FindcursorTrace()
		"Add Tag or note/8",Add_Tag_Note()
		"Reduce Point Density in Plotted Wave", Thindata(100)
		end	
		"-"
		Submenu "Fits"
			"Duffuse Interface Sigmoidal Fit",SigmoidFitWithCursers()	
		end
		"-"
		Submenu "Save Plots or Data"
			"Dump all qrs waves in plot to text file/3",Dumpallwaves(2)
			"Save Waves and Plot Macro for Importing into Igor",DoSaveGraphToFile()
		END
		//"Tag Points",tagpts("Namewave","Ywave" )
	end
end

Macro StdGraph(width,maxY,minY,BW,ylabel,xlabel,modetype,aspect,linewidth,markersize)
	variable/g Root:Packages:P:gmaxy, Root:Packages:P:gminY,Root:Packages:P:gwidth, Root:Packages:P:gBW,Root:Packages:P:modetype,Root:Packages:P:aspect,Root:Packages:P:glinewidth,Root:Packages:P:gmarkersize
	variable maxy=Root:Packages:P:gmaxy,minY=Root:Packages:P:gminY,width=Root:Packages:P:gwidth,BW=Root:Packages:P:gBW,modetype=Root:Packages:P:modetype,aspect=Root:Packages:P:aspect
	variable linewidth=Root:Packages:P:glinewidth,markersize=Root:Packages:P:gmarkersize
	string/g Root:Packages:P:gylabel, Root:Packages:P:gxlabel
	string ylabel=Root:Packages:P:gylabel,xlabel=Root:Packages:P:gxlabel
	prompt BW, "Graph Color",popup, "Color;Black & White;No Change"
	prompt maxy,"Enter max Y"
	prompt minY, "Enter min Y"
	prompt width, "Enter width in inches"
	Prompt aspect, "Enter aspect ratio (1.4)"
	Prompt modetype, "Type of display", popup,"Lines;Sticks;Dots;Markers;Lines &Markers;No change"
	Prompt ylabel,"Y axis Label", popup, "No Change;\f01\Z1610\S6\M\Z16 x SLD (\S-2\M\Z16);\F'arial'\Z16\f01Intensity (cm\S-1\M\Z16);\F'arial'\Z16\f01Intensity;\F'arial'\Z16\f01Reflectivity;\F'arial'\Z12\f01Relative Intensity;"
	Prompt xlabel,"X axis Label", popup, "No Change;\Z16Distance from Si ();\F'arial'\Z16\f01q (\S-1\M\Z16);\F'arial'\Z16\f01q(m\S-1\M\Z16);\F'arial'\Z16\f01Diameter (m);\F'arial'\Z12\f01q (\S-1\M\Z12)"
	prompt linewidth, "Line width"
	prompt markersize, "Marker size"
	silent 1
	Root:Packages:P:gylabel=ylabel
	Root:Packages:P:gxlabel=xlabel
	Root:Packages:P:gmaxy=maxy;Root:Packages:P:gminY=minY;Root:Packages:P:modetype=modetype
	Root:Packages:P:gwidth=width;Root:Packages:P:aspect=aspect
	Root:Packages:P:gBW=BW;Root:Packages:P:glinewidth=linewidth;Root:Packages:P:gmarkersize=markersize
		modetype=modetype-1
	If (width!=0)
		ModifyGraph width=width*72
	endif
	If (aspect!=0)
		ModifyGraph height={Aspect,aspect}
	endif
	ModifyGraph axThick=2;DelayUpdate
	If(!stringmatch(ylabel, "No Change" ))
		Label left ylabel
	endif
	If(!stringmatch(xlabel, "No Change" ))
		Label bottom xlabel
	endif
	
	If ((!maxy==0)&(miny==0))||(!miny==0)&(maxy==0))
		Doalert 0,"If you enter one axis limit, you must enter the other"
		abort
	endif
	If(modetype!=5)
		ModifyGraph mode=modetype
		ChangetoLineandPoints((modetype),1)
	endif
	if((!miny==0)||(!maxy==0))
		SetAxis left minY, maxY
	endif
	//ModifyGraph mirror(bottom)=1;DelayUpdate
	
	if(stringmatch( AxisList(""), "*right*") )
			//SetAxis right 0,1;DelayUpdate
			ModifyGraph margin(top)=15,margin(right)=60, margin(left)=80
		else
			ModifyGraph mirror=1;DelayUpdate
	endif
	ModifyGraph tick=2
	If (markersize!=0)
		ModifyGraph msize=markersize
	endif
	if(linewidth!=0)
		ModifyGraph lsize=linewidth
	endif
	ModifyGraph mirror(bottom)=1
	ModifyGraph font="arial"
	defaultfont arial
	//ModifyGraph fStyle=1,fSize=12
	
	ModifyGraph fStyle=1,fSize=10//font size and bold
	ModifyGraph margin(top)=15,margin(right)=25
	
	If (BW==2)
		ModifyGraph rgb=(0,0,0);DelayUpdate
	endif
	IF (maxy==0)
		Modifygraph width=0, height=0
	endif
endmacro



Function DWS_CreateItem(TheSwitch,NewName)
	string TheSwitch, NewName
//this function creates strings or variables with the name passed
	if (cmpstr(TheSwitch,"string")==0)
		SVAR/Z test=$NewName
		if (!SVAR_Exists(test))
			string/g $NewName
		endif
	endif
	if (cmpstr(TheSwitch,"variable")==0)
		NVAR/Z testNum=$NewName
		if (!NVAR_Exists(testNum))
			variable/g $NewName
		endif
	endif
end

Function/S DWS_FindFolderWithWaveTypes(startDF, levels, WaveTypes, LongShortType)
         String startDF, WaveTypes                  // startDF requires trailing colon.
        Variable levels, LongShortType		//set 1 for long type and 0 for short type return
        			//returns the list of folders with specCommand with "uascan" in it - may not work yet for sbuascan 
        String dfSave
        String list = "", templist
        
        dfSave = GetDataFolder(1)
  	
  	if (!DataFolderExists(startDF))
  		return ""
  	endif
  	
        SetDataFolder startDF
        
        templist = DataFolderDir(0)
        string wl= WaveList("*",";","")

    	 if (Stringmatch(wl,WaveTypes))
		if (LongShortType)
	            		list += startDF + ";"
	      	else
     		      		list += GetDataFolder(0) + ";"
      		endif
        endif
        
        levels -= 1
        if (levels <= 0)
                return list
        endif
        
        String subDF
        Variable index = 0
        do
                String temp
                temp = PossiblyQuoteName(GetIndexedObjName(startDF, 4, index))     	// Name of next data folder.
                if (strlen(temp) == 0)
                        break                                                                           			// No more data folders.
                endif
     	              subDF = startDF + temp + ":"
            		 list +=DWS_FindFolderWithWaveTypes(subDF, levels, "*"+WaveTypes, LongShortType)       	// Recurse.
                index += 1
        while(1)        
        SetDataFolder(dfSave)
        return list
End


function formatgraph(addlabels)
	variable addlabels
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
	//SVAR ListOfGraphFormating=root:Packages:DWSplottingTool:ListOfGraphFormating
	If (!exists(ListOfGraphFormating)==0)
		IR2D_DWSPlotToolInit()
	endif
end

function logspacing(qwave)
	wave qwave
	duplicate/o qwave, tempqwave
	variable pts=numpnts(tempqwave)
	variable logqmax=log(tempqwave(pts-1))
	if (tempqwave[0]==0)
		tempqwave[0]=tempqwave[1]
	endif
	variable logqmin=log(tempqwave[0])
	tempqwave=logqmin+((logqmax-logqmin)/(pts-1))*p
	tempqwave=10^tempqwave	
	qwave=tempqwave
	killwaves/z tempqwave
end




Function Add_Tag_Note()
	String tracename,rwavename,innote
	tracename=FindCursorTrace()
	rwavename=FindPath2CursorWave()
	Prompt innote, "Enter Tag"
	doprompt "Tag Entry Panel",innote 
	//Note $rwaveName, "\r"+innote //uncomment to add note to wave
	string text ="T"+tracename[0,10]+num2str(pcsr(A))
	//string text=UniqueName("T"+tracename[0,10], 14, 0 ) 
	text =CleanupName(text, 0 )
	innote="\f01\Z14"+innote
	Tag/C/F=0/N=$text $rwavename, xcsr(a),innote
End

function/s FindcursorTrace()
	Wave w = CsrWaveRef(A)
	if (!WaveExists(w))		// Cursor is not on any wave.
		Doalert 0, "Cursor is not on any graph\r Put cursor A on a trace"
		abort
	endif
        string WInRecStr=WInrecreation("",0)                                    //creates string containing windows recreation macro
        variable startSpace=strsearch(WInRecStr, "Cursor/P A", 0)+11            //search the string for "Cursor/P A ", 11 is offset from where "Cursor.." starts to the start of name of our wave...
        variable endSpace=strsearch(WInRecStr, " ", startSpace)                 //search for space after name of wave with cursor
    	  string tname=WInRecStr[startSpace,endSpace-1]                            //extract the name of wave with cursor on it
        //tname=PossiblyQuoteName(tname )
       //PRINT tname
       return tname
end

function/s FindPath2cursorWave()
	string  folderpath//,fullpath
	Wave w = CsrWaveRef(A)
	if (!WaveExists(w))		// Cursor is not on any wave.
		Doalert 0, "Cursor is not on any graph\r Put cursor A on a trace"
		abort
	endif
	string wname =nameofwave(w)
	folderpath =getwavesDataFolder(w,1) 
	setdatafolder folderpath
	print folderpath
	//print wname
	return wname
end


Function Dumpallwaves(qSaveError)//currently designed for qrs dump to motofit
	Variable qSaveError
	//Prompt qSaveError,"Save Error Waves Also?", popup,"Yes;No"
	Variable numWaves
	//Doprompt "Save Error Question", qSaveError

	String  FolderName
	string barewavename
	String fileName
	String wname=  WinName(0,1)	
	if( strlen(wname) == 0 )
		DoAlert 0,"No graph!"
		return 0
	else
		DoWindow/F $wname
	endif	
	setdatafolder root:
	GetWindow kwTopWin, wavelist//get all the waves in the graph
	Wave/T wlist=W_WaveList
	numWaves = DimSize(wlist, 0)
	make/O/t/n=(numwaves) wlist1//extract the second column for all paths and wavenames.
	variable n=0
	do//dump each wave to a separate file
		setdatafolder root:
		wname=wlist[n][1]
		barewavename=wlist[n][0]
		if(!cmpstr(barewavename[0],"r"))		
			foldername= getwavesdatafolder($wname,1)
			setdatafolder foldername
			execute "QRSWsaveText(1)"//1 to save s wave and dq wave
		endif
		n+=1
	while (n<numwaves)
	killwaves root:wlist1
end	

function QRSWsaveText(qSaveError)//only wave in target folder are saved
	Variable qSaveError
	//Prompt qSaveError,"Save Error Waves Also?", popup,"Yes;No"
	//Doprompt "Save Error Question", qSaveError
	Silent 1
	pauseupdate
	variable refnum
	String theWaveList=WaveList("*", ";", "WIN:"+WinName(0, 1))
	String simplewavelist=""
	string filename
	variable position1=strsearch(theWaveList,";",0)//find first semicolon
	variable position2=position1
	string wavename=theWaveList[0,(position2-1)]//get wavename
	string Rwave="r"+wavename[1,strlen(wavename)-1]
	string Qwave="q"+wavename[1,strlen(wavename)-1]
	string Swave="s"+wavename[1,strlen(wavename)-1]
	string dQwave="w"+wavename[1,strlen(wavename)-1]// sometimes may be e wave rather than w wave
	simplewavelist=Qwave+";"+Rwave+";"
	if(qSaveError==1)
		if(!cmpstr(wavename[0],"r"))//true for not r
			wave SWv=$Swave
			If (waveexists(SWv))
				simplewavelist+=Swave+";"
			endif
			wave dqWv=$dQwave
			If (waveexists(dqWv))	
				simplewavelist+=dQwave+";"
			endif	
		endif
	variable length=strlen(theWaveList)
	endif
	//Save/J/B/O/W simplewavelist //W saves wavenames
	Save/J/B/O simplewavelist 
End

Function DoSaveGraphToFile()
	
	Variable numWaves
	Variable refnum
	Variable i
	Variable pos0, pos1
	Variable FolderLevel=1

	String TopFolder, FolderName
	String WinRecStr
	String fileName
	String wname=  WinName(0,1)
	
	if( strlen(wname) == 0 )
		DoAlert 0,"No graph!"
		return 0
	else
		DoWindow/F $wname
	endif
	
	TopFolder= wname
	
	setdatafolder root://added by dale
	GetWindow kwTopWin, wavelist//get all the waves in the graph
	Wave/T wlist=W_WaveList
	numWaves = DimSize(wlist, 0)
	
	
	make/O/t/n=(numwaves) wlist1//extract the second column for all paths and wavenames.
	wlist1=wlist[p][1]
	
	
	Redimension/N=(-1,5) wlist//make 5 cols
	
	MakeUniqueFolders(wlist, "data")//fix incase waves have same names
	
	Open/D refnum as wname//sets up a file to save to.  wname is window name which you can change
	filename=S_filename
	
	if (strlen(filename) == 0)
		//DoAlert 0, "You cancelled the Save Graph operation"
		KillWaves/Z wlist
		return 0
	endif
	setdatafolder root://added by dale
	Open refnum as filename
	fprintf refnum, "%s", "IGOR\r"
	fprintf refnum, "%s", "X NewDataFolder/S/O "+TopFolder+"\r"//topfolder is window name.
	close refnum
	
	i = 0
	do
		if (strlen(wlist[i][3]) != 0)//need to set up unique folder
			Open/A refnum as filename
			if (FolderLevel > 1)
				fprintf refnum, "%s", "X SetDataFolder ::\r"
			endif
			fprintf refnum, "%s", "X NewDataFolder/S "+wlist[i][3]+"\r"
			FolderLevel=2
			close refnum
		endif
		Execute "Save/A/T "+wlist[i][1]+" as \""+FileName+"\""

		i += 1
	while (i < numWaves)

	if (FolderLevel > 1)
		Open/A refnum as filename
		fprintf refnum, "%s", "X SetDataFolder ::\r"
		close refnum
	endif

	WinRecStr = WinRecreation(wname, 2)
	i = 0
	FolderName = ""
	do
		pos0=0
		if (strlen(wlist[i][3]) != 0)
			FolderName = ":"+wlist[i][3]+":"
		endif
		do
			pos0=strsearch(WinRecStr, wlist[i][2], pos0+1)
			if (pos0 < 0)
				break
			endif
			WinRecStr[pos0,pos0+strlen(wlist[i][2])-1] = FolderName+PossiblyQuoteName(wlist[i][0])
	
		while (1)
		i += 1
	while (i<numWaves)
	
	Open/A refnum as filename
	
	pos0= strsearch(WinRecStr, "\r", 0)
	pos0= strsearch(WinRecStr, "\r", pos0+1)+1
	fprintf refnum,"X Preferences 0\r"
	do
		pos1= strsearch(WinRecStr, "\r", pos0)
		if( (pos1 == -1)) // %(cmpstr(WinRecStr[pos0,pos0+2],"End") == 0 ) )
			break
		endif
		fprintf refnum,"X%s%s",WinRecStr[pos0,pos1-1],";DelayUpdate\r"
		pos0= pos1+1
	while(1)
	
	fprintf refnum, "%s", "X SetDataFolder ::\r"
	fprintf refnum,"X Preferences 1\r"
	fprintf refnum,"X KillStrings S_waveNames\r"
	close refnum
	
	KillWaves/Z wlist
	return 0
	
end

Function MakeUniqueFolders(wlist, FBaseName)//fixes in case waves have same names
	Wave/T wlist
	String FBaseName
	
	Variable i,j, endi = DimSize(wlist, 0), startj = 0
	Variable FolderNum = 0
	
	wlist[0][3] = ""
	
	i = 1
	do
	
		j = startj
		do
			if (cmpstr(wlist[i][0], wlist[j][0]) == 0)//do any two waves have same name?
				FolderNum +=1
				wlist[i][3] = FBaseName+num2istr(FolderNum)//makes a unique name in col 3
				startj = i
				break
			endif
		
			j += 1
		while (j < i)
	
	
		i += 1
	while (i < endi)
end

//Added Below

function/s FindPath2Trace(Message,tracenamestr)
	string message,tracenamestr
	prompt traceNameStr,Message, popup, TraceNameList("",";",1)
	doprompt "Pick a Trace",traceNameStr
	string  folderpath//,fullpath
	print traceNameStr
	folderpath =getwavesDataFolder(TraceNameToWaveRef("", traceNameStr),1)
	setdatafolder folderpath
	return folderpath
end


function/s FindPathToTraceInGraph(Message)//returns the wavename with path
	string message
	string tracenamestr,folderpath,fullpath
	prompt traceNameStr,Message, popup, TraceNameList("",";",1)
	doprompt "Pick a Trace",traceNameStr
	//Print XWaveName("",traceNameStr)
	Folderpath =getwavesDataFolder(TraceNameToWaveRef("", traceNameStr),1)//without wavename
	setdatafolder folderpath
	Fullpath=getwavesDataFolder(TraceNameToWaveRef("", traceNameStr),2)
	return Fullpath
End Macro


function thindata(spacing)//does not do s wave.  Doesnot average points
	variable spacing
	prompt spacing,"Keep every x points.  Enter x"
	string YwaveNm, XwaveNm,SwaveNm
	string tracenamestr,folderpath,fullpath
	prompt traceNameStr,"Pick Trace", popup, TraceNameList("",";",1)
	doprompt "Pick a Trace",traceNameStr
	setdatafolder getwavesDataFolder(TraceNameToWaveRef("", traceNameStr),1)//without wavename
	Fullpath=getwavesDataFolder(TraceNameToWaveRef("", traceNameStr),2)
	ywaveNm=getfilename(fullpath)
	doprompt "Spacing",spacing
	XwaveNm= XWaveName("",traceNameStr)
	variable newpts=numpnts($YwaveNm )
	newpts=2+floor(newpts/spacing)
	string newYwaveNm,newxwaveNm
	newywaveNm=ywaveNm+"_0"
	newxwaveNm=xwaveNM+"_0"
	duplicate/O $YwaveNm, $newYwaveNm
	duplicate/O $XwaveNM, $newXwaveNm
	Redimension/N=(newpts) $newXwaveNm,$newYwaveNm
	wave localnewxwave=$newXwaveNm
	wave localnewywave=$newYwaveNm
	wave localoldxwave=$XwaveNm
	wave localoldywave=$YwaveNm
	localnewYwave=localoldywave(p*spacing)
	localnewxwave=localoldxwave(p*spacing)
	appendtograph localnewYwave vs localnewxwave
	ModifyGraph mode($newYwaveNm)=3,mrkThick($newYwaveNm)=3	
	doupdate
	removewave(YwaveNm,2)
end

function removewave(Ywave,wanto)
	variable wanto
	string ywave
	prompt wanto, "Remove original wave from graph?",popup,"Yes;No"
	doprompt "Remove Panel",wanto
	if(wanto==1)
		DoAlert 1,"Your about to remove wave original wave from Graph"
		If (V_Flag==1)
			RemoveFromGraph $ywave
		Endif
	endif
end

Function DWS_DrawLineOfSlope(slope)
	variable slope
	string stringslope=num2str(slope)
	DWS_DrawLineOfRequiredSlope(slope,slope,1,stringslope)
End


Function DWS_DrawLineOfAnySlope()

	Variable lineslope,YourNumber,qlabel
	If(!(wintype("")==1))
		DoAlert 0, "Top Window is not a graph"
		Abort
	endif
	string label1
	Prompt lineslope, "Enter slope of line, or select Your number",Popup,"M1;M2;M3;M4;M5;M3.5;M4.5;M2.5;M1.5;Your Number;Vertical;Horizontal;5/3"
	Prompt YourNumber,"If Your number above selected, enter here a number for the slope:"
	Prompt qlabel,"Add a Label?",popup,"Power From Above;My own;No"
	Prompt label1,"If Yes, then here type your label?"

	DoPrompt "Draw line of any slope, select parameters", lineslope, Yournumber, qlabel, label1
	if (V_Flag)
			Abort
	endif
	Silent 1
	do
		if(lineslope==12)
			lineslope=0
			break
		endif
		if(lineslope==10)
			lineslope=YourNumber
			break
		endif
		if(lineslope==6)
			lineslope=3.5
			break
		endif
		if(lineslope==7)
			lineslope=4.5
			break
		endif
		if(lineslope==8)
			lineslope=2.5
			break
		endif
		if(lineslope==9)
			lineslope=1.5
			break
		endif
		if(lineslope==13)
			lineslope=5/3
			break
		endif
		break
	while(1)

	DWS_DrawLineOfRequiredSlope(LineSlope,YourNumber,qLabel,label1)
end


Function DWS_DrawLineOfRequiredSlope(LineSlope,YourNumber,qLabel,label1)
	Variable lineslope,YourNumber,qlabel
	string label1
	If(!(wintype("")==1))
		DoAlert 0, "Top Window is not a graph"
		Abort
	endif
	SetDrawEnv xcoord= bottom,ycoord= left,save
	variable X_start, Y_start
	getAxis bottom
	X_start=ceil((floor(log(V_max))+floor(log(V_min)))/2)
	getAxis left
	Y_start=ceil((ceil(log(V_max))+ceil(log(V_min)))/2)
	if(lineslope==11)														//Vertical
		drawline 10^(X_start),10^(Y_start),10^(X_start+1),10^(Y_start)
	else
		drawline 10^(X_start),10^(Y_start),10^(X_start+1),10^(Y_start-lineslope)
	endif
	if(qlabel==2)
		SetDrawEnv fname= "Times",fstyle= 1;DelayUpdate
		DrawText 10^(X_start),10^(Y_start-1),Label1
	else
		if(qlabel==1)//use power from above
			SetDrawEnv fname= "Times",fstyle= 1;DelayUpdate
			DrawText 10^(X_start),10^(Y_start-1),("-"+num2str(lineslope))
		endif
	endif
EndMacro

Function ZapNegatives(w1,w0,w2)	// replace with zero or NaN 
	Wave w1,w0,w2	
	variable i
		for (i=numpnts(w1);i>=0;i-=1)//zap zeros and negatives
			if ((w1[i] <= 0))
				Deletepoints i, 1, w0,w1,w2
				//w1[p]=NaN;w0[p]=NaN;w2[p]=NaN
			endif	
		endfor
End


Function SetOperationFolder()
	setdatafolder root:
	SetOpsFolder()
end

function SetOpsFolder()
	string theFolder
	Prompt theFolder,"Folder: ",popup,"root;"+DMACorrDir(datafolderdir(1)[7,strlen(datafolderdir(1))])

	if(cmpstr(thefolder,"root")==0)
		setdatafolder root:
	else
		setdatafolder $theFolder
	endif
End

Function/s DMACorrDir(commalist)
	string commalist
	
	//string semicollist
	variable pos=strsearch(commalist,",",0)//finds first comma
	do
		commalist[pos,pos]=";"//changes it to ;
		pos=strsearch(commalist,",",0)//finds next comma
	while(pos!=-1)
Return(commalist)
end


Function SigmoidFitWithCursers()	
	Wave Ya=CsrWaveRef(A), Xa=CsrXWaveRef(A)	//Wave Ya and Xa are expected to be RM_SDM and  QM_SDM
	String Sa="S"+CsrWave(A)[1,32]	
	variable Fitnumber=99, ErrorBar=2,FitMethod=2
	Prompt FitNumber,"Enter The Fit Number:"
	Prompt ErrorBar,"Use Constant Error Bar?",POPUP,"Yes;No"
	Prompt FitMethod, "Select Fit Methord", POPUP, "Sigmodial;Expanded Sigmoidal;Expanded Linear"
	DoPrompt "Enter Parameters", FitNumber,ErrorBar,FitMethod
	
	if(V_Flag) //user choose cancel
		Abort 
	Endif

	Silent 1; Pauseupdate

	// Make sure both cursors are on the same wave.
	String dfA = GetWavesDataFolder(CsrWaveRef(A), 2)
	String dfB = GetWavesDataFolder(CsrWaveRef(B), 2)
	if (CmpStr(dfA, dfB) != 0)
		Abort "Both cursors must be on the same wave."
		return -1
	Endif
	
	//Make sure the current folder is set to cursor wave folder
	String CsrWaveFolder= GetWavesDataFolder(CsrWaveRef(A),1)
	SetDataFolder CsrWaveFolder

	Duplicate/O/R=[pcsr(A), pcsr(B)] Ya, ywave,xw
	Duplicate/O/R=[pcsr(A), pcsr(B)] Xa, xwave,yw

	If (WaveExists($Sa))
		If (ErrorBar==2)	//use error wave as weight wave
			Duplicate/O /R=[pcsr(A), pcsr(B)]$Sa, swave
		Endif	
	Else
		Abort "No Errorwave"+Sa+"Found"
	Endif
		
	String leftlabel,Fit
	Switch(FitMethod)
	Case 1:		
		If (ErrorBar==2)
			swave=swave/ywave
		Endif
		ywave=ln(ywave*xwave^4)
		xwave=xwave^2
		leftlabel="\F'times new roman'\Z18\f01Ln I*q\S4 \M\Z18(cm\S-1\M\Z18 \S-5\M\Z18)"
		Fit="Sigmoidial" + num2str(FitNumber)
		break
	Case 2:		
		If (ErrorBar==2)
			 swave=swave*xwave^2
		Endif
		 ywave=ywave*xwave^4
		 xwave=xwave^2
		Fit="Expanded Sigmoidal" + num2str(FitNumber)
		leftlabel="\F'times new roman'\Z18\f01I*q\S4 \M\Z18(cm\S-1\M\Z18 \S-5\M\Z18)"
		break
	Case 3:
		If (ErrorBar==2)
			 swave=swave*xwave^2
		Endif
		ywave=ywave*xwave^4
		xwave=xwave^2
		leftlabel="\F'times new roman'\Z18\f01I*q\S4 \M\Z18(cm\S-1\M\Z18 \S-5\M\Z18)"
		Fit="Expanded Linear" + num2str(FitNumber)
		break
	EndSwitch

	Display ywave vs xwave as GetDataFolder(0)+Fit
	Label left, leftlabel
	Label bottom,"\F'times new roman'\Z18\f01q\S2 \M\Z18(\S\Z10-2\M\Z18)"
	ShowInfo	

	String Wait2FitGrfName = winname(0,1)
	NewPanel/K=2 /W=(139,341,382,432) as "Pause For Cursor"
	DoWindow/C PauseSigmoidFitLawWithCursers		//Set a Name to Panel
	AutoPositionWindow/E/M=1/R=$Wait2FitGrfName	//Put panel near the graph
	
	DrawText 21,20,"Pick cursors A and B then"
	DrawText 21,40, "Press continue"
	Button NextFit, pos={80,50}, size={92,20},title="Continue"
	//Button Cancel, pos={80,50},title="Cancel"
	Button NextFit, proc=UserPickCursors_ContButtonProc
	//Button Cancel, proc=UserCancelAction
	Cursor/P A, ywave, 0
	Cursor/P B, ywave, numpnts(ywave)-1
	PauseForUser PauseSigmoidFitLawWithCursers, $Wait2FitGrfName

	//Linear Fit Begin
	Variable sigma, E,Kp
	String fitResultsStr
	
	if (ErrorBar==2)
		CurveFit line ywave(xcsr(A), xcsr(B)) /X=xwave /W=swave /I=1 /D
	else
		CurveFit line ywave(xcsr(A), xcsr(B)) /X=xwave /D
	endif
	
	Wave W_coef		// W_coef is created by CurveFit.
	
	Switch (FitMethod)
		Case 1:
			sigma=sqrt(-W_coef[1]/(4*PI*PI)); Kp=exp(W_coef[0])
			sprintf fitResultsStr, fit+"\rSlope = %g, intercept = %g,\r sigma=%g, Kp=%g", W_coef[1], W_coef[0], sigma, Kp
			break
		Case 2:
			sigma=sqrt(-W_coef[1]/(4*PI*PI*W_coef[0])); Kp=W_coef[0]
			sprintf fitResultsStr, fit+"\rSlope = %g, intercept = %g, \rsigma=%g, Kp=%g", W_coef[1], W_coef[0], sigma, Kp
			break
		Case 3:
			E=sqrt(-3*W_coef[1]/(PI*PI*W_coef[0])); Kp=W_coef[0]
			sprintf fitResultsStr, fit+"\rSlope = %g, intercept = %g, \rE=%g, Kp=%g", W_coef[1], W_coef[0], E, Kp
			break
	EndSwitch

	Textbox/C/N=fitResults/A=LT/X=5/Y=5 fitResultsStr
	killwaves/z xwave,ywave,fit_ywave,w_sigma,swave,w_coef
End


Function UserPickCursors_ContButtonProc (ctrlName) :ButtonControl
	String ctrlName	
	DoWindow/K PauseSigmoidFitLawWithCursers	//kill Panel and return to SigmoidFitLawWithCursers
End


function tagpts(namewave,ywave)//tags every point in ywave with namewave elements (text)
	string namewave,ywave
	prompt Ywave,"Pick Ywave", popup, TraceNameList("",";",1)
	prompt namewave,"Pick Name Wave", popup,WaveList("*", ";", "")
	
	doprompt "Pick Trace",Ywave
	string  folderpath,fullpath,boxname,pntname
	folderpath =getwavesDataFolder(TraceNameToWaveRef("", Ywave),1)
	setdatafolder folderpath
	doprompt "Pick Name", namewave
	variable pntsy,pntsn,i
	pntsy=numpnts($ywave)
	pntsn=numpnts($namewave)
	if(!pntsy==pntsn)
		doalert 0, "Wave ranks don't agree"
		abort
	endif
	wave/T w=$namewave
	do
		boxname="box"+num2str(i)
		pntname="\Z10"+w[i]
		//print boxname+"  "+pntname
		Tag/C/n=$boxname $Ywave, i,pntname			
		I=I+1			
	while (i<pntsy)				
end





Function DWS_GenPlotCheckBox(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	string folder=getdatafolder(1)
	SVAR 	ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
	if (cmpstr("GraphLogX",ctrlName)==0)
		//anything needs to be done here?
		ListOfGraphFormating=ReplaceStringByKey("log(bottom)",ListOfGraphFormating, num2str(checked),"=")
		ModifyGraph log(bottom)=checked	
	endif	
	if (cmpstr("GraphLogy",ctrlName)==0)
		ListOfGraphFormating=ReplaceStringByKey("log(left)",ListOfGraphFormating, num2str(checked),"=")
		ModifyGraph log(left)=checked
	endif	
	if (cmpstr("GraphErrors",ctrlName)==0)
		ListOfGraphFormating=ReplaceStringByKey("ErrorBars",ListOfGraphFormating, num2str(checked),"=")
		DWS_AttachErrorBars(1)
	endif	
	if (cmpstr("GraphLegend",ctrlName)==0)
		//anything needs to be done here?
		if(checked)
			NVAR GraphLegendUseFolderNms=root:Packages:GeneralplottingTool:GraphLegendUseFolderNms
			NVAR GraphLegendUseWaveNote=root:Packages:GeneralplottingTool:GraphLegendUseWaveNote
			ListOfGraphFormating=ReplaceStringByKey("Legend",ListOfGraphFormating, num2str(checked+GraphLegendUseFolderNms+2*GraphLegendUseWaveNote),"=")
		else
			ListOfGraphFormating=ReplaceStringByKey("Legend",ListOfGraphFormating, num2str(checked),"=")
		endif
	endif
	variable UseLegend
	if (cmpstr("GraphLegendUseFolderNms",ctrlName)==0)
		//anything needs to be done here?
		UseLegend=NumberByKey("Legend",ListOfGraphFormating,"=")
		if (UseLegend)
			NVAR GraphLegendUseFolderNms=root:Packages:GeneralplottingTool:GraphLegendUseFolderNms
			NVAR GraphLegendUseWaveNote=root:Packages:GeneralplottingTool:GraphLegendUseWaveNote
			ListOfGraphFormating=ReplaceStringByKey("Legend",ListOfGraphFormating, num2str(1+GraphLegendUseFolderNms+2*GraphLegendUseWaveNote),"=")
		endif
	endif
	if (cmpstr("GraphLegendUseWaveNote",ctrlName)==0)
		//anything needs to be done here?
		UseLegend=NumberByKey("Legend",ListOfGraphFormating,"=")
		if (UseLegend)
			NVAR GraphLegendUseFolderNms=root:Packages:GeneralplottingTool:GraphLegendUseFolderNms
			NVAR GraphLegendUseWaveNote=root:Packages:GeneralplottingTool:GraphLegendUseWaveNote
			ListOfGraphFormating=ReplaceStringByKey("Legend",ListOfGraphFormating, num2str(1+GraphLegendUseFolderNms+2*GraphLegendUseWaveNote),"=")
		endif
	endif
	end

function DWS_AttachErrorBars(capwidth)
	variable Capwidth
	string tracelist,activetrace,folderpath,ewave
	tracelist=TraceNameList("",";",1)
	variable i=0,total=ItemsInList(tracelist)
	SVAR ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
	
		do
			activetrace =StringFromList(i, tracelist)
			activetrace=ReplaceString("'", activetrace, "" )
			folderpath =getwavesDataFolder(TraceNameToWaveRef("", activetrace),1)
			setdatafolder folderpath
			if(!NumberByKey("ErrorBars",ListOfGraphFormating,"="))
				Errorbars $activetrace OFF;delayUpdate	
			else
				if (Stringmatch (activetrace,"M_DSM_int*"))
					if (waveexists(M_DSM_Error))
						ErrorBars/T=0/Y=(Capwidth) $activetrace Y,wave=(M_DSM_Error,M_DSM_Error);DelayUpdate
					endif
				elseif (Stringmatch (activetrace,"*DSM_int*"))
					if (waveexists(DSM_Error))
						ErrorBars/T=0/Y=(Capwidth) $activetrace Y,wave=(DSM_Error,DSM_Error);DelayUpdate
					endif
				elseif (Stringmatch (activetrace,"R*"))
					ewave="s"+activetrace[1,32]
					if (waveexists($ewave))
						ErrorBars/T=0/Y=(Capwidth) $activetrace Y,wave=($ewave,$ewave);DelayUpdate
					endif
	
				endif
			endif
			i+=1
		while (i<total)
end


